<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UpgradeController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Log;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});


Route::get('/payment', function () {
    return view('payment');
});

Route::get('/upgrade/{companyId}', [UpgradeController::class, 'showUpgradeForm']);
 Route::get('/form/{companyId}', [UpgradeController::class, 'showUpgradeForm']);
Route::get('/notifications', [NotificationController::class, 'index']);
Route::post('/notifications/{id}/read', [NotificationController::class, 'markAsRead'])->name('notifications.markAsRead');


Route::get('/login', function () {
    return view('login');
});

Route::post('/login', [UserController::class, 'webLogin']);

Route::get('/test-chat/{userId}/{receiverId}', function ($userId, $receiverId) {
    if (!is_numeric($userId) || !is_numeric($receiverId)) {
        abort(400, 'Invalid user or receiver ID');
    }
    Session::put('user_id', $userId);
    Session::put('user_type', 'company');
    return view('chat', ['receiverId' => $receiverId, 'senderId' => $userId]);
});

Route::get('/chat/{receiverId}', function ($receiverId) {
    if (!Session::has('user_id')) {
        return redirect('/login');
    }
    $senderId = Session::get('user_id');
    return view('chat', ['receiverId' => $receiverId, 'senderId' => $senderId]);
});

Route::post('/messages', [UserController::class, 'storeMessage']);
Route::get('/messages', [UserController::class, 'getMessages']); // Fetch history
