<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\CompanyProfileController;
use App\Http\Controllers\CandidateProfileController;
use App\Http\Controllers\CourseController;
use App\Http\Controllers\GroupController;
use App\Http\Controllers\UserRoleController;
use App\Http\Controllers\UserCourseController;
use App\Http\Controllers\CertificationController;
use App\Http\Controllers\UserGroupController;
use App\Http\Controllers\JobController;
use App\Http\Controllers\JobApplicationController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\ReviewController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ReportsController;
use App\Http\Controllers\TransactionsController;
use App\Http\Controllers\RefundsController;
use App\Http\Controllers\StaticContentController;
use App\Http\Controllers\VideoProgressController;
use App\Http\Controllers\ExamQuestionController;
use App\Http\Controllers\ExamAttemptController;
use App\Http\Controllers\InterviewToolController;
use App\Http\Controllers\JobQuestionController;
use App\Http\Controllers\InterviewController;
use App\Http\Controllers\RecruiterController;
use App\Http\Controllers\PlanController;
use App\Http\Controllers\AuditLogController;
use App\Http\Controllers\CandidateSearchController;
use App\Http\Controllers\InterviewPreparationController;
use App\Http\Controllers\CourseCategoryController;
use App\Http\Controllers\SectionController;
use App\Http\Controllers\LessonController;
use App\Http\Controllers\AssignmentController;
use App\Http\Controllers\PracticeTestController;
use App\Http\Controllers\InterviewAttemptController;
use App\Http\Controllers\CouponController;
use App\Http\Controllers\CurrencyController;
use App\Http\Controllers\JobApplicationAnswerController;
use App\Http\Controllers\InterviewQuestionController;
use App\Http\Controllers\InterviewAnswerController;
use App\Http\Controllers\UserSkillController;
use App\Http\Controllers\EmploymentHistoryController;
use App\Http\Controllers\EducationBackgroundController;
use App\Http\Controllers\CourseReviewController;
use App\Http\Controllers\CompanyFeatureUsageController;
use App\Http\Controllers\UpgradeController;
use App\Http\Controllers\SubscriptionHistoryController;
use App\Http\Controllers\GroupMessageController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::prefix('languages')->group(function () {
    Route::get('/', [LanguageController::class, 'index']);
    Route::get('/{id}', [LanguageController::class, 'show']);
    Route::post('/', [LanguageController::class, 'store']);
    Route::put('/{id}', [LanguageController::class, 'update']);
    Route::delete('/{id}', [LanguageController::class, 'destroy']);
});

Route::prefix('users')->group(function () {
Route::get('/', [UserController::class, 'index']);
Route::post('/', [UserController::class, 'store']);
Route::post('/login', [UserController::class, 'login']);
Route::get('/count', [UserController::class, 'totalUsers']);
Route::get('/{id}', [UserController::class, 'show']);
Route::put('/{id}', [UserController::class, 'update']);
Route::delete('/{id}', [UserController::class, 'destroy']);
});

Route::prefix('roles')->group(function () {
    Route::get('/', [RoleController::class, 'index'])->middleware(['auth:sanctum', 'permission:view_roles']);
    Route::get('/{id}', [RoleController::class, 'show'])->middleware(['auth:sanctum', 'permission:view_roles']);
    Route::post('/', [RoleController::class, 'store'])->middleware(['auth:sanctum', 'permission:manage_roles']);
    Route::put('/{id}', [RoleController::class, 'update'])->middleware(['auth:sanctum', 'permission:manage_roles']);
    Route::delete('/{id}', [RoleController::class, 'destroy'])->middleware(['auth:sanctum', 'permission:manage_roles']);
});

Route::prefix('company-profiles')->group(function () {
    Route::get('/', [CompanyProfileController::class, 'index']);
    Route::get('/{id}', [CompanyProfileController::class, 'show']);
    Route::post('/', [CompanyProfileController::class, 'store']);
    Route::put('/{id}', [CompanyProfileController::class, 'update']);
    Route::delete('/{id}', [CompanyProfileController::class, 'destroy']);
    Route::delete('/{id}/logo', [CompanyProfileController::class, 'deleteLogo']);
    Route::get('/{id}/stats', [CompanyProfileController::class, 'getStats']); // Added new stats endpoint
});
Route::prefix('candidate-profiles')->group(function () {
    Route::get('/', [CandidateProfileController::class, 'index']);
    Route::post('/', [CandidateProfileController::class, 'store']);
    Route::get('/search', [CandidateProfileController::class, 'search']); // Moved here to take precedence over /{id}
    Route::get('/{id}', [CandidateProfileController::class, 'show']);
    Route::put('/{id}', [CandidateProfileController::class, 'update']);
    Route::delete('/{id}', [CandidateProfileController::class, 'destroy']);
    Route::delete('/{id}/certification', [CandidateProfileController::class, 'deleteCertification']);
    Route::delete('/{id}/resume', [CandidateProfileController::class, 'deleteResume']);
    Route::get('/{id}/stats', [CandidateProfileController::class, 'getStats']);
});

Route::prefix('courses')->group(function () {
    Route::get('/', [CourseController::class, 'index']);
    Route::get('/counts', [CourseController::class, 'courseCounts']);
    Route::get('/{id}', [CourseController::class, 'show']);
    Route::post('/', [CourseController::class, 'store']);
    Route::put('/{id}', [CourseController::class, 'update']);
    Route::delete('/{id}', [CourseController::class, 'destroy']);
});

Route::prefix('groups')->group(function () {
    Route::get('/', [GroupController::class, 'index']);
    Route::get('/{id}', [GroupController::class, 'show']);
    Route::post('/', [GroupController::class, 'store']);
    Route::put('/{id}', [GroupController::class, 'update']);
    Route::delete('/{id}', [GroupController::class, 'destroy']);
});
Route::prefix('user-roles')->group(function () {
    Route::get('/', [UserRoleController::class, 'index']);
    Route::get('/{id}', [UserRoleController::class, 'show']);
    Route::post('/', [UserRoleController::class, 'store']);
    Route::put('/{id}', [UserRoleController::class, 'update']);
    Route::delete('/{id}', [UserRoleController::class, 'destroy']);
});

Route::prefix('user-courses')->group(function () {
    Route::get('/', [UserCourseController::class, 'index']);
    Route::get('/{id}', [UserCourseController::class, 'show']);
    Route::post('/', [UserCourseController::class, 'store']);
    Route::put('/{id}', [UserCourseController::class, 'update']);
    Route::delete('/{id}', [UserCourseController::class, 'destroy']);
});

Route::prefix('certifications')->group(function () {
    Route::get('/', [CertificationController::class, 'index']);
    Route::get('/{id}', [CertificationController::class, 'show']);
    Route::post('/', [CertificationController::class, 'store']);
    Route::put('/{id}', [CertificationController::class, 'update']);
    Route::delete('/{id}', [CertificationController::class, 'destroy']);
    Route::get('/{id}/download', [CertificationController::class, 'download']); // Added download route
});

Route::prefix('user-groups')->group(function () {
    Route::get('/', [UserGroupController::class, 'index']);
    Route::get('/{id}', [UserGroupController::class, 'show']);
    Route::post('/', [UserGroupController::class, 'store']);
    Route::put('/{id}', [UserGroupController::class, 'update']);
    Route::delete('/{id}', [UserGroupController::class, 'destroy']);
});

Route::prefix('jobs')->group(function () {
    Route::get('/', [JobController::class, 'index']);
    Route::get('/counts', [JobController::class, 'jobCounts']);
    Route::get('/{id}', [JobController::class, 'show']);
    Route::post('/', [JobController::class, 'store']);
    Route::put('/{id}', [JobController::class, 'update']);
    Route::delete('/{id}', [JobController::class, 'destroy']);
});


Route::prefix('job-applications')->group(function () {
    Route::get('/', [JobApplicationController::class, 'index']);
    Route::get('/{id}', [JobApplicationController::class, 'show']);
    Route::post('/', [JobApplicationController::class, 'store']);
    Route::patch('/{id}', [JobApplicationController::class, 'update']); // Updated to patch
    Route::delete('/{id}', [JobApplicationController::class, 'destroy']);
});

Route::prefix('notifications')->group(function () {
    Route::get('/', [NotificationController::class, 'indexApi']);
});
Route::prefix('subscriptions')->group(function () {
    Route::get('/', [SubscriptionController::class, 'index']);
    Route::get('/{id}', [SubscriptionController::class, 'show']);
    Route::post('/', [SubscriptionController::class, 'store']);
    Route::put('/{id}', [SubscriptionController::class, 'update']);
    Route::delete('/{id}', [SubscriptionController::class, 'destroy']);
    Route::get('/by-name', [SubscriptionController::class, 'getSubscriptionByName']);
    Route::post('/upgrade', [SubscriptionController::class, 'upgrade'])->name('subscription.upgrade');
    Route::get('/upgrade-plan', [SubscriptionController::class, 'showUpgradeForm']);
    Route::get('/history/{company_id}', [SubscriptionController::class, 'getSubscriptionHistory']);
});



Route::prefix('user-groups')->group(function () {
    Route::get('/', [UserGroupController::class, 'index']);
    Route::get('/{id}', [UserGroupController::class, 'show']);
    Route::post('/', [UserGroupController::class, 'store']);
    Route::put('/{id}', [UserGroupController::class, 'update']);
    Route::delete('/{id}', [UserGroupController::class, 'destroy']);
});
Route::prefix('messages')->group(function () {
    Route::get('/', [MessageController::class, 'index']);
    Route::get('/{id}', [MessageController::class, 'show']);
    Route::post('/', [MessageController::class, 'store']);
    Route::put('/{id}', [MessageController::class, 'update']);
    Route::delete('/{id}', [MessageController::class, 'destroy']);
});

Route::prefix('group-messages')->group(function () {
    Route::get('/{groupId}', [GroupMessageController::class, 'index']);
    Route::post('/', [GroupMessageController::class, 'store']);
});



Route::prefix('api/notifications')->group(function () {
    Route::get('/', [NotificationController::class, 'indexApi']);
    Route::get('/{id}', [NotificationController::class, 'show']);
    Route::post('/', [NotificationController::class, 'store']);
    Route::put('/{id}', [NotificationController::class, 'update']);
    Route::delete('/{id}', [NotificationController::class, 'destroy']);
    Route::post('/{id}/read', [NotificationController::class, 'markAsReadApi'])->name('api.notifications.markAsRead');
});



Route::prefix('reviews')->group(function () {
    Route::get('/', [ReviewController::class, 'index']);
    Route::get('/{id}', [ReviewController::class, 'show']);
    Route::post('/', [ReviewController::class, 'store']);
    Route::put('/{id}', [ReviewController::class, 'update']);
    Route::delete('/{id}', [ReviewController::class, 'destroy']);
});
Route::prefix('payments')->group(function () {
    Route::get('/', [PaymentController::class, 'index']);
    Route::get('/revenue', [PaymentController::class, 'totalRevenue']); // Added this route
    Route::get('/{id}', [PaymentController::class, 'show']);
    Route::post('/', [PaymentController::class, 'store']);
    Route::put('/{id}', [PaymentController::class, 'update']);
    Route::delete('/{id}', [PaymentController::class, 'destroy']);
    Route::post('/callback/{gateway}', [PaymentController::class, 'callback']);
});

Route::prefix('upgrade')->group(function () {
    Route::post('/plan', [UpgradeController::class, 'upgradePlan']);
    Route::post('/callback/{gateway}', [UpgradeController::class, 'callback']);
});

Route::prefix('reports')->group(function () {
    Route::get('/', [ReportsController::class, 'index']);
    Route::get('/{id}', [ReportsController::class, 'show']);
    Route::post('/', [ReportsController::class, 'store']);
    Route::put('/{id}', [ReportsController::class, 'update']);
    Route::delete('/{id}', [ReportsController::class, 'destroy']);
    Route::post('/generate', [ReportsController::class, 'generateReport']);
    Route::get('/export', [ReportsController::class, 'exportReport']);
    Route::post('/analytics', [ReportsController::class, 'storeAnalytics']);
});

Route::prefix('transactions')->group(function () {
    Route::get('/', [TransactionsController::class, 'index']);
    Route::get('/{id}', [TransactionsController::class, 'show']);
    Route::post('/', [TransactionsController::class, 'store']);
    Route::put('/{id}', [TransactionsController::class, 'update']);
    Route::delete('/{id}', [TransactionsController::class, 'destroy']);
});

Route::prefix('refunds')->group(function () {
    Route::get('/', [RefundsController::class, 'index']);
    Route::get('/{id}', [RefundsController::class, 'show']);
    Route::post('/', [RefundsController::class, 'store']);
    Route::put('/{id}', [RefundsController::class, 'update']);
    Route::delete('/{id}', [RefundsController::class, 'destroy']);
});
Route::prefix('static-content')->group(function () {
    Route::get('/', [StaticContentController::class, 'index']);
    Route::get('/{id}', [StaticContentController::class, 'show']);
    Route::post('/', [StaticContentController::class, 'store']);
    Route::put('/{id}', [StaticContentController::class, 'update']);
    Route::delete('/{id}', [StaticContentController::class, 'destroy']);
});

Route::prefix('video-progress')->group(function () {
    Route::get('/', [VideoProgressController::class, 'index']);
    Route::get('/{id}', [VideoProgressController::class, 'show']);
    Route::post('/', [VideoProgressController::class, 'store']);
    Route::put('/{id}', [VideoProgressController::class, 'update']);
    Route::delete('/{id}', [VideoProgressController::class, 'destroy']);
});

Route::prefix('exam-questions')->group(function () {
    Route::get('/', [ExamQuestionController::class, 'index']);
    Route::get('/{id}', [ExamQuestionController::class, 'show']);
    Route::post('/', [ExamQuestionController::class, 'store']);
    Route::put('/{id}', [ExamQuestionController::class, 'update']);
    Route::delete('/{id}', [ExamQuestionController::class, 'destroy']);
});
Route::prefix('exam-attempt')->group(function () {
    Route::post('/', [ExamAttemptController::class, 'startExam']);
    Route::get('/{id}/questions', [ExamAttemptController::class, 'getExamQuestions']);
    Route::post('/{id}/submit', [ExamAttemptController::class, 'submitExam']);
    Route::get('/user/{user_id}', [ExamAttemptController::class, 'getUserAttempts']);
    Route::get('/{id}', [ExamAttemptController::class, 'show']); // New route for single exam attempt
});
Route::prefix('interview-tools')->group(function () {
    Route::get('/', [InterviewToolController::class, 'index']);
    Route::get('/{id}', [InterviewToolController::class, 'show']);
    Route::post('/', [InterviewToolController::class, 'store']);
    Route::put('/{id}', [InterviewToolController::class, 'update']);
    Route::delete('/{id}', [InterviewToolController::class, 'destroy']);
});

Route::prefix('job-questions')->group(function () {
    Route::get('/', [JobQuestionController::class, 'index']);
    Route::get('/{id}', [JobQuestionController::class, 'show']);
    Route::post('/', [JobQuestionController::class, 'store']);
    Route::put('/{id}', [JobQuestionController::class, 'update']);
    Route::delete('/{id}', [JobQuestionController::class, 'destroy']);
});

Route::prefix('interviews')->group(function () {
    Route::get('/', [InterviewController::class, 'index']);
    Route::get('/{id}', [InterviewController::class, 'show']);
    Route::post('/', [InterviewController::class, 'store']);
    Route::put('/{id}', [InterviewController::class, 'update']);
    Route::delete('/{id}', [InterviewController::class, 'destroy']);
});

Route::prefix('recruiters')->group(function () {
    Route::get('/', [RecruiterController::class, 'index']);
    Route::get('/{id}', [RecruiterController::class, 'show']);
    Route::post('/', [RecruiterController::class, 'store']);
    Route::put('/{id}', [RecruiterController::class, 'update']);
    Route::delete('/{id}', [RecruiterController::class, 'destroy']);
});

Route::prefix('plans')->group(function () {
    Route::get('/', [PlanController::class, 'index']);
    Route::get('/{id}', [PlanController::class, 'show']);
    Route::post('/', [PlanController::class, 'store']);
    Route::put('/{id}', [PlanController::class, 'update']);
    Route::delete('/{id}', [PlanController::class, 'destroy']);
});
Route::prefix('audit-logs')->group(function () {
    Route::get('/', [AuditLogController::class, 'index']);
    Route::get('/{id}', [AuditLogController::class, 'show']);
    Route::post('/', [AuditLogController::class, 'store']);
});
Route::prefix('candidate-search')->group(function () {
    Route::get('/', [CandidateSearchController::class, 'index']);
    Route::get('/{id}', [CandidateSearchController::class, 'show']);
});
Route::prefix('interview-preparation')->group(function () {
    Route::get('/', [InterviewPreparationController::class, 'index']);
    Route::get('/{id}', [InterviewPreparationController::class, 'show']);
    Route::post('/', [InterviewPreparationController::class, 'store']);
    Route::put('/{id}', [InterviewPreparationController::class, 'update']);
    Route::delete('/{id}', [InterviewPreparationController::class, 'destroy']);
    Route::get('/{id}/practice-test', [InterviewPreparationController::class, 'getPracticeTest']);
    Route::post('/{id}/submit-test', [InterviewPreparationController::class, 'submitPracticeTest']);
    Route::post('/interview-preparation/{id}/mark-video-viewed', [InterviewPreparationController::class, 'markVideoViewed']);
});
Route::prefix('course-categories')->group(function () {
    Route::get('/', [CourseCategoryController::class, 'index']);
    Route::get('/{id}', [CourseCategoryController::class, 'show']);
    Route::post('/', [CourseCategoryController::class, 'store']);
    Route::put('/{id}', [CourseCategoryController::class, 'update']);
    Route::delete('/{id}', [CourseCategoryController::class, 'destroy']);
});

Route::prefix('sections')->group(function () {
    Route::get('/', [SectionController::class, 'index']);
    Route::get('/{id}', [SectionController::class, 'show']);
    Route::post('/', [SectionController::class, 'store']);
    Route::put('/{id}', [SectionController::class, 'update']);
    Route::delete('/{id}', [SectionController::class, 'destroy']);
});
Route::prefix('lessons')->group(function () {
    Route::get('/', [LessonController::class, 'index']);
    Route::get('/{id}', [LessonController::class, 'show']);
    Route::post('/', [LessonController::class, 'store']);
    Route::put('/{id}', [LessonController::class, 'update']);
    Route::delete('/{id}', [LessonController::class, 'destroy']);
    Route::delete('/{id}/content-url', [LessonController::class, 'deleteContentUrl']);
});

Route::resource('assignments', AssignmentController::class);
Route::post('/assignments/{id}/submit', [AssignmentController::class, 'submitAssignment']);
Route::post('/assignments/{id}/grade', [AssignmentController::class, 'gradeAssignment']);

Route::apiResource('practice-tests', PracticeTestController::class);
Route::apiResource('interview-attempts', InterviewAttemptController::class);

Route::apiResource('coupons', CouponController::class);

Route::prefix('currencies')->group(function () {
    Route::get('/', [CurrencyController::class, 'index']);
    Route::post('/', [CurrencyController::class, 'store']);
    Route::get('/{id}', [CurrencyController::class, 'show']);
    Route::put('/{id}', [CurrencyController::class, 'update']);
    Route::delete('/{id}', [CurrencyController::class, 'delete']);
});

Route::prefix('job-application-answers')->group(function () {
    Route::get('/', [JobApplicationAnswerController::class, 'index']);
    Route::post('/', [JobApplicationAnswerController::class, 'store']);
    Route::get('/{id}', [JobApplicationAnswerController::class, 'show']);
    Route::put('/{id}', [JobApplicationAnswerController::class, 'update']);
    Route::delete('/{id}', [JobApplicationAnswerController::class, 'destroy']);
});
Route::apiResource('interview-questions', InterviewQuestionController::class);
Route::get('jobs/{jobId}/interview-questions', [InterviewQuestionController::class, 'getByJobId'])->name('interview-questions.by-job');
Route::apiResource('interview-answers', InterviewAnswerController::class);

Route::apiResource('employment-history', EmploymentHistoryController::class);
Route::apiResource('education-background', EducationBackgroundController::class);
Route::apiResource('course-reviews', CourseReviewController::class);

Route::get('/user-skills', [UserSkillController::class, 'index'])->name('user-skills.index');
Route::post('/user-skills', [UserSkillController::class, 'store'])->name('user-skills.store');
Route::get('/user-skills/{id}', [UserSkillController::class, 'show'])->name('user-skills.show');
Route::put('/user-skills/{id}', [UserSkillController::class, 'update'])->name('user-skills.update');
Route::delete('/user-skills/{id}', [UserSkillController::class, 'destroy'])->name('user-skills.destroy');

Route::prefix('company-feature-usages')->group(function () {
    Route::get('/', [CompanyFeatureUsageController::class, 'index']);
    Route::get('/{id}', [CompanyFeatureUsageController::class, 'show']);
    Route::post('/', [CompanyFeatureUsageController::class, 'store']);
    Route::put('/{id}', [CompanyFeatureUsageController::class, 'update']);
    Route::delete('/{id}', [CompanyFeatureUsageController::class, 'destroy']);
    Route::post('/increment', [CompanyFeatureUsageController::class, 'incrementUsage']);
    Route::get('/status/{companyId}', [CompanyFeatureUsageController::class, 'getUsageStatus']);
    Route::get('/usage/{companyId}', [CompanyFeatureUsageController::class, 'getCompanyFeatureUsage']);
    Route::post('/sync/{companyId}', [CompanyFeatureUsageController::class, 'syncUsageLimits']);
});
