<!DOCTYPE html>
<html>
<head>
    <title>Group Chat</title>
    <script src="https://js.pusher.com/7.0/pusher.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <div id="chat-container">
        <ul id="messages"></ul>
        <input type="text" id="message-input" placeholder="Type a message...">
        <button onclick="sendMessage()">Send</button>
    </div>

    <script>
        // Pusher configuration
        Pusher.logToConsole = true;
        var pusher = new Pusher('{{ env('PUSHER_APP_KEY') }}', {
            cluster: '{{ env('PUSHER_APP_CLUSTER') }}',
            forceTLS: true,
            authEndpoint: '/broadcasting/auth',
        });

        var channel = pusher.subscribe('presence-group.{{ $groupId }}');
        channel.bind('App\\Events\\NewGroupMessage', function(data) {
            $('#messages').append('<li>' + data.message.Content + ' (from ' + data.message.sender.Email + ')</li>');
        });

        channel.here((members) => {
            console.log('Members online:', members);
        });

        function sendMessage() {
            var content = $('#message-input').val();
            $.post('/group-messages', {
                Group_id: {{ $groupId }},
                Sender_id: {{ auth()->user()->User_id }},
                Content: content,
                _token: '{{ csrf_token() }}'
            }, function(response) {
                $('#message-input').val('');
            });
        }
    </script>
</body>
</html>
