<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
           $table->bigIncrements('Payment_id');
            $table->unsignedBigInteger('User_id');
            $table->unsignedBigInteger('Subscription_id')->nullable();
            $table->unsignedBigInteger('Coupon_id')->nullable();
            $table->unsignedBigInteger('Course_id')->nullable();
            $table->decimal('Amount', 10, 2);
            $table->char('Currency', 3);
            $table->enum('Payment_status', ['pending', 'completed', 'failed'])->default('pending');
            $table->string('Payment_gateway', 50)->nullable();
            $table->string('Transaction_id', 255)->nullable();
            $table->timestamp('Created_at')->useCurrent();
            $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();

            // Add foreign key constraints (assuming related tables exist)
            $table->foreign('User_id')->references('User_id')->on('Users')->onDelete('cascade');
            $table->foreign('Subscription_id')->references('Subscription_id')->on('Subscriptions')->onDelete('set null');
            $table->foreign('Coupon_id')->references('Coupon_id')->on('coupons')->onDelete('set null');
            $table->foreign('Course_id')->references('Course_id')->on('Courses')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};




