<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewFieldsToUserCoursesTable extends Migration
{
    public function up()
    {
        Schema::table('User_courses', function (Blueprint $table) {
            $table->timestamp('Last_activity')->nullable()->after('Mock_interviews_completed');
            $table->integer('Total_attempts')->default(1)->after('Last_activity');
            $table->string('Completion_status')->nullable()->after('Total_attempts');
        });
    }

    public function down()
    {
        Schema::table('User_courses', function (Blueprint $table) {
            $table->dropColumn(['Last_activity', 'Total_attempts', 'Completion_status']);
        });
    }
}
