<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubscriptionHistoryTable extends Migration
{
    public function up()
    {
        Schema::create('subscription_history', function (Blueprint $table) {
            $table->id('history_id');
            $table->foreignId('subscription_id')->constrained('Subscriptions', 'Subscription_id')->onDelete('cascade');
            $table->foreignId('plan_id')->constrained('plans', 'Plan_id')->onDelete('cascade');
            $table->foreignId('company_id')->constrained('company_profiles', 'Company_id')->onDelete('cascade');
            $table->string('name')->nullable();
            $table->dateTime('start_date');
            $table->dateTime('end_date')->nullable();
            $table->string('status')->default('active');
            $table->decimal('amount', 10, 2)->nullable();
            $table->string('payment_gateway')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('subscription_history');
    }
}
