<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('company_feature_usage', function (Blueprint $table) {
            $table->id('Usage_id')->unsigned()->autoIncrement();
            $table->bigInteger('Company_id')->unsigned();
            $table->bigInteger('Plan_id')->unsigned()->nullable();
            $table->string('Feature_Name', 255)->comment('e.g., post_jobs, search_candidates');
            $table->integer('Usage_Count')->default(0)->comment('Current usage of the feature');
            $table->integer('Max_Usage')->default(0)->comment('Maximum allowed usage from Feature_Set');
            $table->timestamp('Start_Date')->useCurrent();
            $table->timestamp('End_Date')->nullable();
            $table->timestamp('Created_at')->useCurrent();
            $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();

            $table->foreign('Company_id')->references('Company_id')->on('company_profiles')->onDelete('cascade');
            $table->foreign('Plan_id')->references('Plan_id')->on('plans')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('company_feature_usage');
    }
};
