<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('Company_profiles', function (Blueprint $table) {
            $table->unsignedBigInteger('Subscription_id')->nullable()->after('Plan_id');
            $table->foreign('Subscription_id', 'company_profiles_subscription_id_foreign')
                  ->references('Subscription_id')->on('subscriptions')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('Company_profiles', function (Blueprint $table) {
            $table->dropForeign('company_profiles_subscription_id_foreign');
            $table->dropColumn('Subscription_id');
        });
    }
};
