<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('Company_profiles', function (Blueprint $table) {
            $table->unsignedBigInteger('Plan_id')->nullable()->after('User_id');
            $table->foreign('Plan_id')->references('Plan_id')->on('plans')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('Company_profiles', function (Blueprint $table) {
            $table->dropForeign(['Plan_id']);
            $table->dropColumn('Plan_id');
        });
    }
};
