<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('Jobs', function (Blueprint $table) {
            $table->enum('Status', ['pending', 'approved', 'rejected', 'closed'])->default('pending')->after('Job_type');
        });
    }

    public function down(): void
    {
        Schema::table('Jobs', function (Blueprint $table) {
            $table->dropColumn('Status');
        });
    }
};
