<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::dropIfExists('job_application_answers');

        Schema::create('job_application_answers', function (Blueprint $table) {
            $table->id('Answer_id');
            $table->unsignedBigInteger('Application_id');
            $table->unsignedBigInteger('Question_id');
            $table->text('Answer_text')->nullable()->comment('For text-based answers');
            $table->json('Answer_choice')->nullable()->comment('For multiple/single choice answers');
            $table->integer('Answer_rating')->nullable()->comment('For rating scale answers (1-5, 1-10, etc.)');
            $table->boolean('Answer_boolean')->nullable()->comment('For boolean (Yes/No) answers');
            $table->decimal('Score', 5, 2)->nullable()->comment('Automated or manual score based on weight');
            $table->timestamp('Created_at')->useCurrent();
            $table->foreign('Application_id', 'job_application_answers_application_id_foreign')
                  ->references('Application_id')->on('job_applications')->onDelete('cascade');
            $table->foreign('Question_id', 'job_application_answers_question_id_foreign')
                  ->references('Question_id')->on('job_questions')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('job_application_answers');

        Schema::create('job_application_answers', function (Blueprint $table) {
            $table->id('Answer_id');
            $table->unsignedBigInteger('Application_id');
            $table->unsignedBigInteger('Question_id');
            $table->text('Answer_text');
            $table->timestamp('Created_at')->useCurrent();
            $table->foreign('Application_id')->references('Application_id')->on('job_applications')->onDelete('cascade');
            $table->foreign('Question_id')->references('Question_id')->on('job_questions')->onDelete('cascade');
        });
    }
};
