<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('job_applications', function (Blueprint $table) {
            $table->enum('Status', ['draft', 'pending', 'reviewing', 'shortlisted', 'interviewing', 'accepted', 'rejected'])->default('draft')->change();
        });
    }

    public function down(): void
    {
        Schema::table('job_applications', function (Blueprint $table) {
            $table->enum('Status', ['pending', 'accepted', 'rejected'])->default('pending')->change();
        });
    }
};
