<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('interview_questions', function (Blueprint $table) {
            $table->unsignedBigInteger('Interview_question_id')->autoIncrement();
            $table->unsignedBigInteger('Job_id');
            $table->text('Question_text');
            $table->text('Expected_answer')->nullable();
            $table->enum('Difficulty_level', ['easy', 'medium', 'hard'])->default('medium');
            $table->integer('Time_limit')->default(120)->comment('Time in seconds');
            $table->timestamp('Created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('Updated_at')->default(DB::raw('CURRENT_TIMESTAMP'))->onUpdate(DB::raw('CURRENT_TIMESTAMP'));
            $table->foreign('Job_id', 'interview_questions_job_id_foreign')
                  ->references('Job_id')->on('jobs')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('interview_questions');
    }
};
