<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFieldsToPracticeTestsTable extends Migration
{
    public function up()
    {
        Schema::table('practice_tests', function (Blueprint $table) {
            $table->integer('Total_questions')->default(0)->after('Passed');
            $table->enum('Difficulty_level', ['easy', 'medium', 'hard'])->default('medium')->after('Total_questions');
            $table->integer('Duration_minutes')->nullable()->after('Difficulty_level');
        });
    }

    public function down()
    {
        Schema::table('practice_tests', function (Blueprint $table) {
            $table->dropColumn(['Total_questions', 'Difficulty_level', 'Duration_minutes']);
        });
    }
}
?>
