<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->unsignedBigInteger('Currency_id')->nullable()->after('Price');
            $table->foreign('Currency_id')->references('Currency_id')->on('currencies')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('plans', function (Blueprint $table) {
            $table->dropForeign(['Currency_id']);
            $table->dropColumn('Currency_id');
        });
    }
};
