<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('User_courses', function (Blueprint $table) {
            // Rename Created_at to created_at if it exists
            if (Schema::hasColumn('User_courses', 'Created_at')) {
                $table->renameColumn('Created_at', 'created_at');
            }
            // Add created_at if it doesn't exist
            if (!Schema::hasColumn('User_courses', 'created_at')) {
                $table->timestamp('created_at')->useCurrent()->after('Completed_at');
            }
            // Add updated_at if it doesn't exist
            if (!Schema::hasColumn('User_courses', 'updated_at')) {
                $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate()->after('created_at');
            }
        });
    }

    public function down(): void
    {
        Schema::table('User_courses', function (Blueprint $table) {
            // Drop updated_at if it exists
            if (Schema::hasColumn('User_courses', 'updated_at')) {
                $table->dropColumn('updated_at');
            }
            // Reverse rename or drop created_at
            if (Schema::hasColumn('User_courses', 'created_at')) {
                $table->renameColumn('created_at', 'Created_at');
            } elseif (Schema::hasColumn('User_courses', 'Created_at')) {
                // If created_at was added, drop it
                $table->dropColumn('Created_at');
            }
        });
    }
};
