<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('User_courses', function (Blueprint $table) {
            $table->unsignedBigInteger('Payment_id')->nullable()->after('Course_id');
            $table->string('Enrollment_number', 36)->unique()->nullable()->after('Payment_id');
            $table->foreign('Payment_id')->references('Payment_id')->on('Payments')->onDelete('set null');
            $table->unique(['User_id', 'Course_id'], 'unique_user_course');
        });
    }

    public function down(): void
    {
        Schema::table('User_courses', function (Blueprint $table) {
            $table->dropForeign(['Payment_id']);
            $table->dropColumn(['Payment_id', 'Enrollment_number']);
            $table->dropUnique('unique_user_course');
        });
    }
};
