<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('Payments', function (Blueprint $table) {
            $table->unsignedBigInteger('Course_id')->after('Subscription_id')->nullable();
            $table->foreign('Course_id')->references('Course_id')->on('Courses')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('Payments', function (Blueprint $table) {
            $table->dropForeign(['Course_id']);
            $table->dropColumn('Course_id');
        });
    }
};
