<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsToLessonsTable extends Migration
{
    public function up()
    {
        Schema::table('lessons', function (Blueprint $table) {
            $table->boolean('Has_assignments')->default(false)->after('Metadata');
            $table->boolean('Has_practice_tests')->default(false)->after('Has_assignments');
            $table->boolean('Has_mock_interviews')->default(false)->after('Has_practice_tests');
            $table->boolean('Has_interactive_elements')->default(false)->after('Has_mock_interviews');
        });
    }

    public function down()
    {
        Schema::table('lessons', function (Blueprint $table) {
            $table->dropColumn('Has_interactive_elements');
            $table->dropColumn('Has_mock_interviews');
            $table->dropColumn('Has_practice_tests');
            $table->dropColumn('Has_assignments');
        });
    }
}
