<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsToVideoProgressTable extends Migration
{
    public function up()
    {
        Schema::table('video_progress', function (Blueprint $table) {
            $table->integer('Interactive_elements_completed')->nullable()->after('Watched_duration');
            $table->unsignedBigInteger('Assignment_id')->nullable()->after('Interactive_elements_completed');
            $table->foreign('Assignment_id')->references('Assignment_id')->on('assignments')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('video_progress', function (Blueprint $table) {
            $table->dropForeign(['Assignment_id']);
            $table->dropColumn('Assignment_id');
            $table->dropColumn('Interactive_elements_completed');
        });
    }
}
