<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAssignmentsPracticeTestsPaymentAndMockInterviewsToUserCoursesTable extends Migration
{
    public function up()
    {
        Schema::table('User_courses', function (Blueprint $table) {
            $table->integer('Assignments_completed')->default(0)->after('Completed_at');
            $table->integer('Practice_tests_completed')->default(0)->after('Assignments_completed');
            $table->unsignedBigInteger('Payment_id')->nullable()->after('Practice_tests_completed');
            $table->integer('Mock_interviews_completed')->default(0)->after('Payment_id');
            $table->foreign('Payment_id')->references('Payment_id')->on('Payments')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('User_courses', function (Blueprint $table) {
            $table->dropForeign(['Payment_id']);
            $table->dropColumn(['Assignments_completed', 'Practice_tests_completed', 'Payment_id', 'Mock_interviews_completed']);
        });
    }
}
