<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddStatusAndCertificateVersionToCertificationsTable extends Migration
{
    public function up()
    {
        Schema::table('Certifications', function (Blueprint $table) {
            $table->enum('Status', ['issued', 'revoked', 'pending'])->default('pending')->after('Serial_number');
            $table->string('Certificate_version', 20)->nullable()->after('Status');
        });
    }

    public function down()
    {
        Schema::table('Certifications', function (Blueprint $table) {
            $table->dropColumn(['Status', 'Certificate_version']);
        });
    }
}
