<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddVerificationCodeAndSerialNumberToCertificationsTable extends Migration
{
    public function up()
    {
        Schema::table('certifications', function (Blueprint $table) {
            $table->string('Verification_code', 100)->nullable()->after('Course_id'); // Assuming 'id' as a reference point
            $table->string('Serial_number', 50)->unique()->after('Verification_code');
        });
    }

    public function down()
    {
        Schema::table('certifications', function (Blueprint $table) {
            $table->dropColumn(['Verification_code', 'Serial_number']);
        });
    }
}
