<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDifficultyPointsAndMetadataToExamQuestionsTable extends Migration
{
    public function up()
    {
        Schema::table('exam_questions', function (Blueprint $table) {
            $table->enum('Difficulty', ['easy', 'medium', 'hard'])->nullable()->after('Question_text');
            $table->integer('Points')->default(1)->after('Difficulty')->comment('Points value for the question');
            $table->longText('Metadata')->nullable()->after('Points')->comment('Dynamic data (e.g., hints, tags)');
        });
    }

    public function down()
    {
        Schema::table('exam_questions', function (Blueprint $table) {
            $table->dropColumn(['Difficulty', 'Points', 'Metadata']);
        });
    }
}
