<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLessonsTable extends Migration
{
    public function up()
    {
        // Drop course_content table if it exists (backup data first if needed)
        Schema::dropIfExists('course_content');

        Schema::create('lessons', function (Blueprint $table) {
            $table->id('Lesson_id');
            $table->unsignedBigInteger('Section_id');
            $table->enum('Type', ['video', 'quiz', 'assignment', 'document'])->comment('Content type');
            $table->string('Title');
            $table->string('Content_url')->nullable();
            $table->integer('Duration')->nullable()->comment('Duration in seconds for videos');
            $table->integer('Order')->default(0)->comment('Sequence within section');
            $table->longText('Metadata')->nullable()->comment('Dynamic data (e.g., difficulty, tags)');
            $table->timestamp('Created_at')->useCurrent();
            $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();

            $table->foreign('Section_id')->references('Section_id')->on('sections')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('lessons');
    }
}
