<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSectionsTable extends Migration
{
    public function up()
    {
        Schema::create('sections', function (Blueprint $table) {
            $table->id('Section_id');
            $table->unsignedBigInteger('Course_id');
            $table->string('Title');
            $table->text('Description')->nullable();
            $table->integer('Order')->default(0)->comment('Sequence within course');
            $table->longText('Metadata')->nullable()->comment('Dynamic data (e.g., prerequisites)');
            $table->timestamp('Created_at')->useCurrent();
            $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();

            $table->foreign('Course_id')->references('Course_id')->on('courses')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('sections');
    }
}
