<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('User_roles', function (Blueprint $table) {
            $table->bigIncrements('User_role_id'); // BIGINT(20) UNSIGNED AUTO_INCREMENT
            $table->unsignedBigInteger('User_id'); // BIGINT(20) UNSIGNED
            $table->unsignedBigInteger('Role_id'); // BIGINT(20) UNSIGNED
            $table->foreign('User_id')->references('User_id')->on('Users')->onDelete('cascade');
            $table->foreign('Role_id')->references('Role_id')->on('Roles')->onDelete('cascade');
            $table->index(['User_id', 'Role_id'], 'Idx_user_role');

        });
    }

    public function down(): void
    {
        Schema::dropIfExists('User_roles');
    }
};
