<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('Roles', function (Blueprint $table) {
            $table->bigIncrements('Role_id'); // BIGINT(20) UNSIGNED AUTO_INCREMENT
            $table->string('Name', 100)->unique()->index(); // VARCHAR(100) with index
            $table->longText('Permissions')->nullable(); // LONGTEXT for JSON data
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('Roles');
    }
};
