<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ModifySubscriptionsTableAddPlanId extends Migration
{
    public function up()
    {
        Schema::table('Subscriptions', function (Blueprint $table) {
            // Add Plan_id column
            $table->unsignedBigInteger('Plan_id')->after('User_id')->nullable();
            $table->foreign('Plan_id')
                  ->references('Plan_id')
                  ->on('plans')
                  ->onDelete('cascade')
                  ->name('subscriptions_plan_id_foreign');
            // Drop Plan_name column
            $table->dropColumn('Plan_name');
        });
    }

    public function down()
    {
        Schema::table('Subscriptions', function (Blueprint $table) {
            $table->string('Plan_name', 100)->after('User_id');
            $table->dropForeign('subscriptions_plan_id_foreign');
            $table->dropColumn('Plan_id');
        });
    }
}
