<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAuditLogsTable extends Migration
{
    public function up()
    {
        Schema::create('audit_logs', function (Blueprint $table) {
            $table->id('Log_id');
            $table->unsignedBigInteger('User_id')->notNullable();
            $table->string('Action', 255)->notNullable();
            $table->text('Details')->nullable();
            $table->timestamp('Created_at')->useCurrent();

            $table->foreign('User_id')
                  ->references('User_id')
                  ->on('users')
                  ->onDelete('cascade')
                  ->name('audit_logs_user_id_foreign');
        });
    }

    public function down()
    {
        Schema::dropIfExists('audit_logs');
    }
}
