<?php

  use Illuminate\Database\Migrations\Migration;
  use Illuminate\Database\Schema\Blueprint;
  use Illuminate\Support\Facades\Schema;

  class CreatePlansTable extends Migration
  {
      public function up()
      {
          Schema::create('plans', function (Blueprint $table) {
              $table->id('Plan_id');
              $table->string('Name', 100)->notNullable();
              $table->json('Features')->notNullable()->comment('JSON array of features, e.g., ["unlimited_postings","premium_visibility"]');
              $table->decimal('Price', 10, 2)->notNullable()->default(0.00);
              $table->string('Currency', 3)->notNullable()->default('USD');
              $table->integer('Duration')->notNullable()->default(30)->comment('Duration in days');
              $table->timestamp('Created_at')->useCurrent();
              $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();
          });
      }

      public function down()
      {
          Schema::dropIfExists('plans');
      }
  }
