<?php

  use Illuminate\Database\Migrations\Migration;
  use Illuminate\Database\Schema\Blueprint;
  use Illuminate\Support\Facades\Schema;

  class CreateRecruitersTable extends Migration
  {
      public function up()
      {
          Schema::create('recruiters', function (Blueprint $table) {
              $table->id('Recruiter_id');
              $table->unsignedBigInteger('Company_id')->notNullable();
              $table->unsignedBigInteger('User_id')->notNullable();
              $table->timestamp('Created_at')->useCurrent();
              $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();

              $table->foreign('Company_id')
                    ->references('Company_id')
                    ->on('company_profiles')
                    ->onDelete('cascade')
                    ->name('recruiters_company_id_foreign');
              $table->foreign('User_id')
                    ->references('User_id')
                    ->on('users')
                    ->onDelete('cascade')
                    ->name('recruiters_user_id_foreign');
          });
      }

      public function down()
      {
          Schema::dropIfExists('recruiters');
      }
  }
