<?php

  use Illuminate\Database\Migrations\Migration;
  use Illuminate\Database\Schema\Blueprint;
  use Illuminate\Support\Facades\Schema;

  class CreateInterviewsTable extends Migration
  {
      public function up()
      {
          Schema::create('interviews', function (Blueprint $table) {
              $table->id('Interview_id');
              $table->unsignedBigInteger('Application_id')->notNullable();
              $table->dateTime('Date')->notNullable();
              $table->string('Video_link', 255)->nullable()->comment('Link for Zoom/Google Meet');
              $table->enum('Status', ['scheduled', 'completed', 'canceled'])->notNullable()->default('scheduled');
              $table->timestamp('Created_at')->useCurrent();
              $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();

              $table->foreign('Application_id')
                    ->references('Application_id')
                    ->on('job_applications')
                    ->onDelete('cascade')
                    ->name('interviews_application_id_foreign');
          });
      }

      public function down()
      {
          Schema::dropIfExists('interviews');
      }
  }
