<?php

  use Illuminate\Database\Migrations\Migration;
  use Illuminate\Database\Schema\Blueprint;
  use Illuminate\Support\Facades\Schema;

  class CreateInterviewToolsTable extends Migration
  {
      public function up()
      {
          Schema::create('interview_tools', function (Blueprint $table) {
              $table->id('Tool_id');
              $table->unsignedBigInteger('User_id')->notNullable();
              $table->enum('Type', ['mock_interview', 'practice_test'])->notNullable();
              $table->string('Title', 255)->notNullable();
              $table->string('Content_url', 255)->nullable();
              $table->decimal('Score', 5, 2)->nullable();
              $table->timestamp('Created_at')->useCurrent();
              $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();

              $table->foreign('User_id')
                    ->references('User_id')
                    ->on('users')
                    ->onDelete('cascade')
                    ->name('interview_tools_user_id_foreign');
          });
      }

      public function down()
      {
          Schema::dropIfExists('interview_tools');
      }
  }
