<?php

  use Illuminate\Database\Migrations\Migration;
  use Illuminate\Database\Schema\Blueprint;
  use Illuminate\Support\Facades\Schema;

  class CreateExamAttemptsTable extends Migration
  {
      public function up()
      {
          Schema::create('exam_attempts', function (Blueprint $table) {
              $table->id('Attempt_id');
              $table->unsignedBigInteger('User_id')->notNullable();
              $table->unsignedBigInteger('Course_id')->notNullable();
              $table->unsignedBigInteger('Content_id')->notNullable();
              $table->integer('Score')->notNullable()->default(0)->comment('Number of correct answers');
              $table->integer('Total_questions')->notNullable()->default(0);
              $table->integer('Pass_threshold')->notNullable()->default(0)->comment('Minimum correct answers to pass');
              $table->boolean('Is_passed')->notNullable()->default(0);
              $table->timestamp('Attempted_at')->notNullable()->useCurrent();
              $table->timestamp('Created_at')->useCurrent();
              $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();

              $table->foreign('User_id')
                    ->references('User_id')
                    ->on('users')
                    ->onDelete('cascade')
                    ->name('exam_attempts_user_id_foreign');
              $table->foreign('Course_id')
                    ->references('course_id')
                    ->on('courses')
                    ->onDelete('cascade')
                    ->name('exam_attempts_course_id_foreign');
              $table->foreign('Content_id')
                    ->references('Content_id')
                    ->on('course_content')
                    ->onDelete('cascade')
                    ->name('exam_attempts_content_id_foreign');
          });
      }

      public function down()
      {
          Schema::dropIfExists('exam_attempts');
      }
  }
