<?php

  use Illuminate\Database\Migrations\Migration;
  use Illuminate\Database\Schema\Blueprint;
  use Illuminate\Support\Facades\Schema;

  class CreateVideoProgressTable extends Migration
  {
      public function up()
      {
          Schema::create('video_progress', function (Blueprint $table) {
              $table->id('Progress_id');
              $table->unsignedBigInteger('User_id')->notNullable();
              $table->unsignedBigInteger('Content_id')->notNullable();
              $table->integer('Watched_duration')->default(0)->comment('Watched duration in seconds');
              $table->boolean('Is_completed')->default(0);
              $table->timestamp('Completed_at')->nullable();
              $table->timestamp('Created_at')->useCurrent();
              $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();

              $table->foreign('User_id')
                    ->references('User_id')
                    ->on('users')
                    ->onDelete('cascade')
                    ->name('video_progress_user_id_foreign');
              $table->foreign('Content_id')
                    ->references('Content_id')
                    ->on('course_content')
                    ->onDelete('cascade')
                    ->name('video_progress_content_id_foreign');
          });
      }

      public function down()
      {
          Schema::dropIfExists('video_progress');
      }
  }
