<?php

  use Illuminate\Database\Migrations\Migration;
  use Illuminate\Database\Schema\Blueprint;
  use Illuminate\Support\Facades\Schema;

  class CreateStaticContentTable extends Migration
  {
      public function up()
      {
          Schema::create('static_content', function (Blueprint $table) {
              $table->id('Content_id');
              $table->string('Page_name', 255)->notNullable();
              $table->longText('Content')->notNullable();
              $table->unsignedBigInteger('Updated_by')->notNullable();
              $table->timestamp('Created_at')->useCurrent();
              $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();

              $table->index('Updated_by', 'Idx_updated_by');
              $table->foreign('Updated_by')
                    ->references('User_id')
                    ->on('users')
                    ->onDelete('cascade')
                    ->name('static_content_user_id_foreign');
          });
      }

      public function down()
      {
          Schema::dropIfExists('static_content');
      }
  }
