<?php

  use Illuminate\Database\Migrations\Migration;
  use Illuminate\Database\Schema\Blueprint;
  use Illuminate\Support\Facades\Schema;

  class CreateAnalyticsTable extends Migration
  {
      public function up()
      {
          Schema::create('Analytics', function (Blueprint $table) {
              $table->id('Analytic_id');
              $table->enum('Type', ['user_engagement', 'job_placement', 'training_stats'])->notNullable();
              $table->json('Data');
              $table->timestamp('Recorded_at')->useCurrent();
          });
      }

      public function down()
      {
          Schema::dropIfExists('Analytics');
      }
  }
