<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class CreateRefundsTable extends Migration
{
    public function up()
    {
        Schema::create('Refunds', function (Blueprint $table) {
            $table->id('Refund_id');
            $table->unsignedBigInteger('Payment_id')->nullable()->index();
            $table->unsignedBigInteger('Transaction_id')->nullable()->index();
            $table->decimal('Amount', 10, 2)->default(0.00);
            $table->string('Currency', 3)->default('INR');
            $table->string('Reason')->nullable();
            $table->string('Status')->default('requested');
            $table->string('Gateway_response')->nullable();
            $table->timestamp('Requested_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->timestamp('Processed_at')->nullable();
            $table->timestamps();

            $table->foreign('Payment_id')->references('Payment_id')->on('Payments')->onDelete('set null');
            $table->foreign('Transaction_id')->references('Transaction_id')->on('Transactions')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('Refunds');
    }
}
