<?php

  use Illuminate\Database\Migrations\Migration;
  use Illuminate\Database\Schema\Blueprint;
  use Illuminate\Support\Facades\Schema;

  class CreateTransactionsTable extends Migration
  {
      public function up()
      {
          Schema::create('Transactions', function (Blueprint $table) {
              $table->id('Transaction_id');
              $table->unsignedBigInteger('Payment_id')->nullable()->index();
              $table->string('Transaction_type')->default('payment');
              $table->decimal('Amount', 10, 2)->default(0.00);
              $table->string('Currency', 3)->default('INR');
              $table->string('Payment_method')->default('razorpay');
              $table->string('Status')->default('pending');
              $table->string('Gateway_response')->nullable();
              $table->timestamp('Processed_at')->nullable();
              $table->timestamps();

              $table->foreign('Payment_id')->references('Payment_id')->on('Payments')->onDelete('set null');
          });
      }

      public function down()
      {
          Schema::dropIfExists('Transactions');
      }
  }
