<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('Reviews', function (Blueprint $table) {
            $table->engine = 'InnoDB'; // Explicitly set InnoDB for foreign keys
            $table->bigIncrements('Review_id');
            $table->unsignedBigInteger('User_id');
            $table->unsignedBigInteger('Job_id');
            $table->integer('Rating')->unsigned()->between(1, 5);
            $table->text('Comment')->nullable();
            $table->timestamp('Created_at')->useCurrent();
            $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();
            $table->foreign('User_id')->references('User_id')->on('Users')->onDelete('cascade');
            $table->foreign('Job_id')->references('Job_id')->on('Jobs')->onDelete('cascade');
            $table->index(['User_id', 'Job_id'], 'Idx_user_job');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('Reviews');
    }
};
