<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('Notifications', function (Blueprint $table) {
            $table->engine = 'InnoDB'; // Explicitly set InnoDB for foreign keys
            $table->bigIncrements('Notification_id');
            $table->unsignedBigInteger('User_id');
            $table->string('Title', 255);
            $table->text('Message');
            $table->enum('Type', ['info', 'warning', 'success', 'error'])->default('info');
            $table->boolean('Is_read')->default(false);
            $table->timestamp('Created_at')->useCurrent();
            $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();
            $table->foreign('User_id')->references('User_id')->on('Users')->onDelete('cascade');
            $table->index('User_id', 'Idx_user_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('Notifications');
    }
};
