<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('Subscriptions', function (Blueprint $table) {
            $table->engine = 'InnoDB'; // Explicitly set InnoDB for foreign keys
            $table->bigIncrements('Subscription_id');
            $table->unsignedBigInteger('User_id');
            $table->string('Plan_name', 100);
            $table->date('Start_date');
            $table->date('End_date')->nullable();
            $table->enum('Status', ['active', 'expired', 'canceled'])->default('active');
            $table->timestamp('Created_at')->useCurrent();
            $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();
            $table->foreign('User_id')->references('User_id')->on('Users')->onDelete('cascade');
            $table->index('User_id', 'Idx_user_id');
        });
    }
 
    public function down(): void
    {
        Schema::dropIfExists('Subscriptions');
    }
};
