<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('User_groups', function (Blueprint $table) {
            $table->engine = 'InnoDB'; // Explicitly set InnoDB for foreign keys
            $table->bigIncrements('User_group_id');
            $table->unsignedBigInteger('User_id');
            $table->unsignedBigInteger('Group_id');
            $table->timestamp('Joined_at')->useCurrent();
            $table->foreign('User_id')->references('User_id')->on('Users')->onDelete('cascade');
            $table->foreign('Group_id')->references('Group_id')->on('Groups')->onDelete('cascade');
            $table->index(['User_id', 'Group_id'], 'Idx_user_group');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('User_groups');
    }
};
