<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Ensure Languages table exists
        Schema::create('Courses', function (Blueprint $table) {
            $table->engine = 'InnoDB'; // Explicitly set InnoDB for foreign keys
            $table->bigIncrements('Course_id');
            $table->string('Title', 255);
            $table->text('Description')->nullable();
            $table->string('Content_url', 255)->nullable();
            $table->boolean('Is_paid')->default(false);
            $table->decimal('Price', 10, 2)->default(0.00);
            $table->unsignedBigInteger('Language_id')->nullable();
            $table->timestamp('Created_at')->useCurrent();
            $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();
            $table->foreign('Language_id')->references('Language_id')->on('Languages')->onDelete('set null');
            $table->index('Language_id', 'Idx_language_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('Courses');
    }
};
