<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('Company_profiles', function (Blueprint $table) {
            $table->bigIncrements('Company_id');
            $table->unsignedBigInteger('User_id');
            $table->string('Company_name', 255);
            $table->text('Description')->nullable();
            $table->string('Logo_url', 255)->nullable();
            $table->string('Location', 255)->nullable();
            $table->timestamp('Created_at')->useCurrent();
            $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();
            $table->foreign('User_id')->references('User_id')->on('Users')->onDelete('cascade');
            $table->index('User_id', 'Idx_user_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('Company_profiles');
    }
};
