<?php

namespace App\Models;

use App\Events\LessonCompletedEvent;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VideoProgress extends Model
{
    protected $table = 'video_progress';
    protected $primaryKey = 'Progress_id';
    public $timestamps = true;

    protected $fillable = [
        'User_id',
        'Lesson_id',
        'Watched_duration',
        'Last_position',
        'Is_completed',
        'Interactive_elements_completed',
        'Assignment_id',
        'Last_activity',
        'Total_attempts',
        'Completion_status',
        'Total_duration', // Added
    ];

    protected $casts = [
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
        'Is_completed' => 'boolean',
        'Watched_duration' => 'integer',
        'Last_position' => 'integer',
        'Interactive_elements_completed' => 'integer',
        'Total_attempts' => 'integer',
        'Total_duration' => 'integer', // Added
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }

    public function lesson()
    {
        return $this->belongsTo(Lesson::class, 'Lesson_id', 'Lesson_id');
    }

    protected static function boot()
    {
        parent::boot();

        static::updated(function ($videoProgress) {
            if ($videoProgress->isDirty('Is_completed') && $videoProgress->Is_completed) {
                event(new LessonCompletedEvent($videoProgress));
            }
        });
    }
}
