<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserGroup extends Model
{
    protected $table = 'user_groups';
    protected $primaryKey = 'User_group_id';
    public $timestamps = false; // Only Joined_at, not standard timestamps

    protected $fillable = [
        'User_id',
        'Group_id',
        'Joined_at',
    ];

    protected $casts = [
        'Joined_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }

    public function group()
    {
        return $this->belongsTo(Group::class, 'Group_id', 'Group_id');
    }
}
