<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\HasMany;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'users';
    protected $primaryKey = 'User_id';
    public $timestamps = true;

    protected $fillable = [
        'Email',
        'mobile_number',
        'Password_hash',
        'User_type',
        'Status',
    ];

    protected $casts = [
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
        'User_type' => 'string',
        'Status' => 'string',
    ];

    protected $hidden = [
        'Password_hash',
        'remember_token',
    ];

    public function getAuthPassword()
    {
        return $this->Password_hash;
    }

    public function roles(): BelongsToMany
    {
        return $this->belongsToMany(Role::class, 'user_roles', 'User_id', 'Role_id');
    }

    public function candidateProfile(): HasOne
    {
        return $this->hasOne(CandidateProfile::class, 'User_id', 'User_id');
    }

    public function companyProfile(): HasOne
    {
        return $this->hasOne(CompanyProfile::class, 'User_id', 'User_id');
    }

    public function skills(): HasMany
    {
        return $this->hasMany(UserSkill::class, 'User_id', 'User_id');
    }

    public function certifications(): HasMany
    {
        return $this->hasMany(Certification::class, 'User_id', 'User_id');
    }
    
    public function currentSubscription(): BelongsTo
    {
        return $this->belongsTo(Subscription::class, 'Subscription_id', 'Subscription_id')
            ->where('Status', 'active')
            ->where('Start_date', '<=', now())
            ->where('End_date', '>=', now());
    }
}
