<?php

  namespace App\Models;

  use Illuminate\Database\Eloquent\Model;

  class Transaction extends Model
  {
      protected $table = 'transactions';
      protected $primaryKey = 'Transaction_id';
      public $timestamps = true;

      protected $fillable = [
          'Payment_id',
          'Transaction_type',
          'Amount',
          'Currency',
          'Payment_method',
          'Status',
          'Gateway_response',
          'Processed_at',
      ];

      public function payment()
      {
          return $this->belongsTo(Payment::class, 'Payment_id', 'Payment_id');
      }
  }
